rule Win32_Ransomware_TargetCompany : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "TARGETCOMPANY"
        description         = "Yara rule that detects TargetCompany ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "TargetCompany"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            E8 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 59 53 68 ?? ?? ?? ?? 6A ?? 53 6A
            ?? 68 ?? ?? ?? ?? 56 FF D7 89 85 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ??
            89 85 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 56 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 83
            BD ?? ?? ?? ?? ?? 75 ?? BF ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 56 8D 75 ?? E8 ?? ?? ??
            ?? 50 89 5D ?? E8 ?? ?? ?? ?? 53 6A ?? E8 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? E9 ?? ??
            ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59
            E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 53 68
            ?? ?? ?? ?? 6A ?? 53 6A ?? 68 ?? ?? ?? ?? 56 FF D7 89 85 ?? ?? ?? ?? 83 F8 ?? 0F 84
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B B5 ?? ?? ??
            ?? 6A ?? 5F 53 57 56 FF B5 ?? ?? ?? ?? 89 BD ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 57 52 50
            89 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 25 ?? ?? ?? ?? 33 FF 3B F3 89 85
            ?? ?? ?? ?? 7F ?? 7C ?? 81 BD ?? ?? ?? ?? ?? ?? ?? ?? 77 ?? 33 FF 47 EB ?? B9 ?? ??
            ?? ?? 3B C1 73 ?? 53 51 56 FF B5 ?? ?? ?? ?? 89 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 50
        }

        $encrypt_files_p2 = {
            56 FF B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ??
            ?? ?? 89 95 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 3B FB 8B 3D ?? ?? ?? ?? 89 9D ?? ?? ?? ??
            89 9D ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 89 85 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 59 89 85 ?? ?? ?? ?? 3B C3 0F 84 ?? ?? ?? ?? 53 8D 8D ?? ?? ?? ?? 51 FF B5 ??
            ?? ?? ?? 50 FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 45 ?? 50 FF B5 ?? ?? ?? ?? 8D 4D
            ?? FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 53 53 53 FF B5 ??
            ?? ?? ?? FF D7 53 8D 85 ?? ?? ?? ?? 50 FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF B5 ??
            ?? ?? ?? FF D6 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 85 ?? ?? ?? ?? 3B C3 0F 84 ??
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 3B C3 0F 86 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 53 53 FF B5 ??
            ?? ?? ?? FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF D7 53 8D 85 ?? ?? ?? ?? 50 FF B5 ??
            ?? ?? ?? FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 45 ?? 50 FF B5 ??
            ?? ?? ?? 8D 4D ?? FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 53
            FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF D7 53 8D 85 ?? ?? ?? ?? 50
            FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF D6 8B 85 ?? ?? ?? ?? 01 85
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 11 85 ?? ?? ?? ?? FF 8D ?? ?? ?? ?? 0F 85 ?? ?? ?? ??
            FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 6A ?? 53 53 33 C0 50 FF B5 ?? ?? ?? ?? FF D7 8B
            BD ?? ?? ?? ?? 53 8D 85 ?? ?? ?? ?? 50 6A ?? 8D 45 ?? 50 57 FF D6 53 8D 85 ?? ?? ??
            ?? 50 6A ?? 8D 45 ?? 50 57 FF D6 53 8D 85 ?? ?? ?? ?? 50 6A ?? 68 ?? ?? ?? ?? 57 FF
            D6 57 FF 15 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8
        }

        $remote_connection_p1 = {
            55 8B EC 83 EC ?? 53 56 33 F6 57 8D 5D ?? 89 75 ?? E8 ?? ?? ?? ?? 89 75 ?? 56 56 56
            FF 75 ?? 56 FF 15 ?? ?? ?? ?? 8B D8 89 5D ?? 3B DE 0F 84 ?? ?? ?? ?? C7 45 ?? ?? ??
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 33 FF 6A ?? 8D
            45 ?? 50 FF 74 BD ?? 53 FF 15 ?? ?? ?? ?? 47 83 FF ?? 72 ?? 56 56 6A ?? 56 56 FF 75
            ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 89 45 ?? 3B C6 0F 84 ?? ?? ?? ?? 33 C9 80 7D ?? ??
            B8 ?? ?? ?? ?? 0F 95 C1 56 49 23 C8 03 C8 81 C9 ?? ?? ?? ?? 51 56 56 56 FF 75 ?? 89
            4D ?? 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B D8 3B DE 0F 84 ?? ?? ?? ?? 6A ??
            5F 8D 45 ?? 50 8D 45 ?? 50 6A ?? 53 89 7D ?? 89 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ??
            81 4D ?? ?? ?? ?? ?? 57 8D 45 ?? 50 6A ?? 53 FF 15 ?? ?? ?? ?? FF 75 ?? 8B 45 ?? FF
            75 ?? F7 D8 1B C0 50 FF 75 ?? 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 33 FF 56 56 8D 45 ??
            50 53 89 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 03 C7 50 FF 75 ?? E8 ?? ?? ??
            ?? 59 59 8D 4D ?? 51 FF 75 ?? 89 45 ?? 03 C7 50 53 FF 15 ?? ?? ?? ?? 03 7D ?? 39 75
            ?? 75 ?? 53 FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ??
            39 75 ?? 75 ?? 33 C0 40 39 45 ?? 74 ?? 89 45 ?? E9 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ??
            ?? FF 75 ?? E8 ?? ?? ?? ?? 8B 45 ?? 59 59 5F 5E 5B C9 C3
        }

        $remote_connection_p2 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 56 57 8D 9D ?? ?? ?? ??
            8B F9 E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 8D 45
            ?? 50 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 75
            ?? B8 ?? ?? ?? ?? 50 8D 45 ?? 50 57 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ??
            50 FF 15 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83
            C4 ?? 8B F8 85 F6 74 ?? 56 E8 ?? ?? ?? ?? 59 85 FF 74 ?? 57 E8 ?? ?? ?? ?? 59 FF B5
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D ?? 5F 5E 33
            CD 5B E8 ?? ?? ?? ?? C9 C3
        }

        $generate_key = {
            0F 31 0F AF C8 0F AF CE 0F AF 8D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 53 33 FF 47 57 53 53
            8D 85 ?? ?? ?? ?? 50 89 8D ?? ?? ?? ?? FF D6 3B C3 75 ?? FF 15 ?? ?? ?? ?? 3D ?? ??
            ?? ?? 75 ?? 6A ?? 57 53 53 8D 85 ?? ?? ?? ?? 50 FF D6 3B C3 74 ?? 8D 85 ?? ?? ?? ??
            50 6A ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? ?? ?? E8 ?? ?? ??
            ?? 59 53 FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C7
            B9 ?? ?? ?? ?? 8B 11 8B F2 C1 EE ?? 33 F2 69 F6 ?? ?? ?? ?? 03 F0 89 71 ?? 83 C1 ??
            40 81 F9 ?? ?? ?? ?? 7C ?? 57 A3 ?? ?? ?? ?? FF 15
        }

        $find_files_p1 = {
            8D 85 ?? ?? ?? ?? 53 53 50 53 FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ??
            83 F8 ?? 0F 84 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85
            ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF
            D6 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57
            FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 C4 ?? F6 85 ?? ?? ?? ?? ?? 74 ?? 33 F6 0F B7
            C6 FF 34 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ??
            ?? 46 66 83 FE ?? 72 ?? 6A ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 68 ??
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ??
            ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? F6 85 ?? ?? ?? ??
            ?? 0F 84 ?? ?? ?? ?? 83 A5 ?? ?? ?? ?? ?? 0F B7 B5 ?? ?? ?? ?? 8D 34 B5
        }

        $find_files_p2 = {
            FF 36 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 50 FF D3 FF 36 89 85 ?? ??
            ?? ?? FF D3 8B 8D ?? ?? ?? ?? 3B C8 0F 84 ?? ?? ?? ?? FF 85 ?? ?? ?? ?? 66 83 BD ??
            ?? ?? ?? ?? 72 ?? C6 85 ?? ?? ?? ?? ?? 0F B6 85 ?? ?? ?? ?? FF 34 85 ?? ?? ?? ?? 8D
            85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? FE 85 ?? ?? ?? ?? 80 BD ?? ?? ?? ??
            ?? 72 ?? 6A ?? E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 ?? 6A ?? 59 FF B5 ?? ?? ?? ?? 33 C0
            8B FE F3 AB 66 8B 85 ?? ?? ?? ?? 66 89 46 ?? FF D3 8D 44 00 ?? 50 E8 ?? ?? ?? ?? 59
            FF B5 ?? ?? ?? ?? 89 46 ?? 50 FF 15 ?? ?? ?? ?? 56 6A ?? 6A ?? FF 35 ?? ?? ?? ?? FF
            15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BF ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50
            FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF 15
            ?? ?? ?? ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF B5 ?? ?? ?? ?? FF
            15 ?? ?? ?? ?? 83 C4 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB ?? 56 FF 15 ?? ?? ??
            ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B
            4D ?? 5F 5E 33 CD 33 C0 5B E8 ?? ?? ?? ?? C9 C2
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            $generate_key
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            all of ($remote_connection_p*)
        )
}